-- [ja] 情報読み込み 
local drFile={};
local drInfo={};
drFile=getenv("drFile");
drInfo=getenv("drInfo");
-- [ja] 現在選択中の番号（1～数） 
local sys_seldrill=1;

local jud=GetUserPref_Theme("UserJudgementLabel");

local WHEEL_CENTER_X=SCREEN_CENTER_X-80;
local WHEEL_CENTER_Y=SCREEN_CENTER_Y+30;
local BANNER_CENTER_X=WHEEL_CENTER_X;
local BANNER_CENTER_Y=WHEEL_CENTER_Y-200;
local STATS_CENTER_X=WHEEL_CENTER_X;
local STATS_CENTER_Y=WHEEL_CENTER_Y+140;
local INFO_CENTER_X=math.max(SCREEN_CENTER_X+200,SCREEN_RIGHT-180);
local INFO_CENTER_Y=SCREEN_CENTER_Y-20;

local t=Def.ActorFrame{};
local t2=Def.ActorFrame{};
if #drFile>0 then
t2[#t2+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:queuecommand("Set");
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	SetRCommand=function(self)
		self:queuecommand("Set");
	end;
	SetCommand=function(self)
		self:finishtweening();
		if not getenv("sys_seldrill") then
			sys_seldrill=1;
		else
			sys_seldrill=getenv("sys_seldrill");
		end;
		if getenv("sys_move") then
			if getenv("sys_move")=="left" then
				self:queuecommand("MoveLeft");
			elseif getenv("sys_move")=="right" then
				self:queuecommand("MoveRight");
			end;
			setenv("sys_move",nil);
		end;
	end;
-- Wheel 
	LoadActor(THEME:GetPathG("_SelectMusic/white","wheelbg"))..{
		InitCommand=function(self)
			self:x(WHEEL_CENTER_X-20);
			self:y(WHEEL_CENTER_Y-20);
		end;
	};
	Def.Quad{
		SetCommand=function(self)
			self:zoomto(174,174);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:diffuse(D3Color("Text"));
		end;
		MoveLeftCommand=function(self)
			self:zoomto(124,124);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0.5);
			self:linear(0.2);
			self:zoomto(174,174);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
		MoveRightCommand=function(self)
			self:zoomto(124,124);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0.5);
			self:linear(0.2);
			self:zoomto(174,174);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
	};
	Def.Banner{
		SetCommand=function(self)
			self:Load(drInfo[drFile[sys_seldrill].."-Jacket"]);
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
		end;
		MoveLeftCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0.5);
			self:linear(0.2);
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0);
		end;
		MoveRightCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0.5);
			self:linear(0.2);
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0);
		end;
	};
	-- [ja] 左隣 
	Def.Banner{
		SetCommand=function(self)
			local s=sys_seldrill-1;
			if s<1 then s=#drFile; end;
			self:Load(drInfo[drFile[s].."-Jacket"]);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0.5);
		end;
		MoveLeftCommand=function(self)
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0.5);
		end;
		MoveRightCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-240);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
	};
	-- [ja] 右隣 
	Def.Banner{
		SetCommand=function(self)
			local s=sys_seldrill+1;
			if s>#drFile then s=1; end;
			self:Load(drInfo[drFile[s].."-Jacket"]);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0.5);
		end;
		MoveLeftCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+240);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
		MoveRightCommand=function(self)
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0.5);
		end;
	};
	LoadActor(THEME:GetPathG("EditMenu","Left"))..{
		InitCommand=function(self)
			self:x(WHEEL_CENTER_X-120);
			self:y(WHEEL_CENTER_Y);
		end;
	};
	LoadActor(THEME:GetPathG("EditMenu","Right"))..{
		InitCommand=function(self)
			self:x(WHEEL_CENTER_X+120);
			self:y(WHEEL_CENTER_Y);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=cmd(maxwidth,300;);
		SetCommand=function(self)
			self:diffuse(Str2Color(drInfo[drFile[sys_seldrill].."-Color"]));
			local c1=Str2Color(drInfo[drFile[sys_seldrill].."-Color"])[1];
			local c2=Str2Color(drInfo[drFile[sys_seldrill].."-Color"])[2];
			if tonumber(c2)<0.8 then
				self:strokecolor(Color("White"));
			else
				self:strokecolor(Color("Outline"));
			end;
			self:settext(drInfo[drFile[sys_seldrill].."-Title"]);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y-118);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=cmd(zoom,0.65;maxwidth,300/0.65;
			diffuse,D3Color("Text");strokecolor,Color("White");
			x,WHEEL_CENTER_X;y,WHEEL_CENTER_Y-98);
		SetCommand=function(self)
			self:settext(""..sys_seldrill.."/"..#drFile);
		end;
	};
-- Banner 
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
		InitCommand=function(self)
			self:x(BANNER_CENTER_X);
			self:y(BANNER_CENTER_Y);
			self:zoomto(320,116);
		end;
	};
	Def.Sprite{
		Name="Banner";
		SetCommand=function(self)
			self:Load(drInfo[drFile[sys_seldrill].."-Banner"]);
			self:scaletofit(-150,-48,150,48);
			self:x(BANNER_CENTER_X);
			self:y(BANNER_CENTER_Y);
		end;
	};
-- Stats 
	LoadActor(THEME:GetPathG("_SelectMusic/white","score"))..{
		InitCommand=function(self)
			self:x(STATS_CENTER_X);
			self:y(STATS_CENTER_Y);
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(STATS_CENTER_X-82);
			self:y(STATS_CENTER_Y-16);
			self:zoom(0.5);
			self:settext("Cleared Level");
		end;
		SetCommand=function(self)
			if drInfo[drFile[sys_seldrill].."-ClearName"]=="NO DATA" then
				self:diffuse(Color("Black"));
				self:diffusealpha(0.3);
			else
				self:diffuse(D3Color("Text"));
				self:diffusealpha(1.0);
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(STATS_CENTER_X);
			self:y(STATS_CENTER_Y+5);
		end;
		SetCommand=function(self)
			if drInfo[drFile[sys_seldrill].."-ClearName"]=="NO DATA" then
				self:diffuse(Color("Black"));
				self:diffusealpha(0.3);
			else
				self:diffuse(D3Color("Text"));
				self:diffusealpha(1.0);
			end;
			self:settext(drInfo[drFile[sys_seldrill].."-ClearName"]);
		end;
	};
-- Information
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
	--Def.Quad{
		InitCommand=function(self)
			self:zoomto(220,360);
			self:x(INFO_CENTER_X);
			self:y(INFO_CENTER_Y);
	--		self:diffuse(Color("White"));
	--		self:diffusealpha(0.8);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X-100);
			self:y(INFO_CENTER_Y-160);
			self:zoom(0.75);
			self:settext("PlayStyle : ");
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			local style=string.upper(drInfo[drFile[sys_seldrill].."-Style"]);
			if style=="SINGLE" then
				style="4B Mode";
			elseif style=="DOUBLE" then
				style="8B Mode";
			end;
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X+100);
			self:y(INFO_CENTER_Y-160);
			self:settext(style);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X-100);
			self:y(INFO_CENTER_Y-120);
			self:zoom(0.75);
			self:settext("Best\nController : ");
		end;
	};
	LoadActor(THEME:GetPathG("_Drills/drill","controllers"))..{
		InitCommand=function(self)
			self:x(INFO_CENTER_X+50);
			self:y(INFO_CENTER_Y-95);
			self:animate(false);
		end;
		SetCommand=function(self)
			local ctrl=string.upper(drInfo[drFile[sys_seldrill].."-Ctrl"]);
			if ctrl=="PAD" then
				self:setstate(0);
			elseif ctrl=="KEY" then
				self:setstate(1);
			else
				self:setstate(2);
			end;
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X-100);
			self:y(INFO_CENTER_Y-30);
			self:zoom(0.75);
			self:settext("ClearBorder : ");
		end;
	};
	Def.Quad{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:x(INFO_CENTER_X-100-1);
			self:y(INFO_CENTER_Y-10);
			self:zoomto(200+2,10+2);
		end;
	};
	Def.Quad{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:diffusetopedge(Color("White"));
			self:x(INFO_CENTER_X-100);
			self:y(INFO_CENTER_Y-10);
			self:zoomto(200,10);
		end;
	};
	Def.Quad{
		InitCommand=function(self)
			self:horizalign(right);
			self:diffuse(Color("Yellow"));
			self:diffusetopedge(Color("White"));
			self:x(INFO_CENTER_X+100);
			self:y(INFO_CENTER_Y-10);
		end;
		SetCommand=function(self)
			self:zoomto((100-tonumber(drInfo[drFile[sys_seldrill].."-Border"]))*2,10);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X+100);
			self:y(INFO_CENTER_Y-30);
		end;
		SetCommand=function(self)
			self:settext(drInfo[drFile[sys_seldrill].."-Border"].."%");
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X-100);
			self:y(INFO_CENTER_Y+20);
			self:zoom(0.75);
			self:settext("LifeMeter : ");
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(right);
			self:x(INFO_CENTER_X+100);
			self:y(INFO_CENTER_Y+20);
			self:maxwidth(110);
		end;
		SetCommand=function(self)
			local lf=string.upper(drInfo[drFile[sys_seldrill].."-Life"]);
			self:strokecolor(Color("White"));
			if lf=="NORMAL" or lf=="NORECOVER" or lf=="HARD" then
				self:diffuse(D3Color("Text"));
				self:settext(lf);
			elseif lf=="HARDNORECOVER" then
				self:diffuse(D3Color("Text"));
				self:settext("HARD NORECOVER");
			elseif lf=="SUDDENDEATH" or lf=="ULTIMATE" then
				self:diffuse(D3Color("Red"));
				self:settext(lf);
			elseif lf=="FC" or lf=="W3FC" then
				self:strokecolor(Color("Outline"));
				self:diffuse(GameColor.Judgment["JudgmentLine_W3"]);
				self:settext("FULLCOMBO");
			elseif lf=="PFC" or lf=="W2FC" then
				self:strokecolor(Color("Outline"));
				self:diffuse(GameColor.Judgment["JudgmentLine_W2"]);
				self:settext(_JudgementLabel2(jud,"JudgmentLine_W2").." FC");
			elseif lf=="MFC" or lf=="W1FC" then
				self:strokecolor(Color("Outline"));
				self:diffuse(GameColor.Judgment["JudgmentLine_W1"]);
				self:settext(_JudgementLabel2(jud,"JudgmentLine_W1").." FC");
			elseif lf=="1" then
				self:diffuse(D3Color("Red"));
				self:settext(lf.." Life");
			else
				self:diffuse(D3Color("Text"));
				self:settext(lf.." Lives");
			end;
		end;
	};
	LoadActor(THEME:GetPathG("_Drills/drill","life"))..{
		InitCommand=function(self)
			self:x(INFO_CENTER_X);
			self:y(INFO_CENTER_Y+45);
			self:animate(false);
		end;
		SetCommand=function(self)
			local lf=string.upper(drInfo[drFile[sys_seldrill].."-Life"]);
			if lf=="NORMAL" or lf=="NORECOVER" or lf=="HARD"
				or lf=="HARDNORECOVER" or lf=="SUDDENDEATH"
				or lf=="ULTIMATE" then
				self:setstate(0);
			elseif lf=="1" or lf=="FC" or lf=="W3FC"
				or lf=="PFC" or lf=="W2FC"
				or lf=="MFC" or lf=="W1FC" then
				self:setstate(2);
			else
				self:setstate(1);
			end;
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X-100);
			self:y(INFO_CENTER_Y+80);
			self:zoom(0.75);
			self:settext("LifeDifficulty : ");
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X+100);
			self:y(INFO_CENTER_Y+80);
		end;
		SetCommand=function(self)
			self:settext(drInfo[drFile[sys_seldrill].."-LDif"]);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X-100);
			self:y(INFO_CENTER_Y+105);
			self:zoom(0.75);
			self:settext("TimingDifficulty : ");
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(INFO_CENTER_X+100);
			self:y(INFO_CENTER_Y+105);
		end;
		SetCommand=function(self)
			self:settext(drInfo[drFile[sys_seldrill].."-TDif"]);
		end;
	};
	LoadActor(THEME:GetPathG("_Drills/drill","options1"))..{
		InitCommand=function(self)
			self:x(INFO_CENTER_X-45);
			self:y(INFO_CENTER_Y+150);
			self:animate(false);
		end;
		SetCommand=function(self)
			if drInfo[drFile[sys_seldrill].."-SOpt"]=="true" then
				self:setstate(0);
			else
				self:setstate(1);
			end;
		end;
	};
	LoadActor(THEME:GetPathG("_Drills/drill","options2"))..{
		InitCommand=function(self)
			self:x(INFO_CENTER_X+45);
			self:y(INFO_CENTER_Y+150);
			self:animate(false);
		end;
		SetCommand=function(self)
			if drInfo[drFile[sys_seldrill].."-ROpt"]=="true" then
				self:setstate(0);
			else
				self:setstate(1);
			end;
		end;
	};
};
end;
--[[
-- [ja] （不使用だけど資料として書いておく）プレイヤーネームの取得方法
	PROFILEMAN:GetPlayerName(getenv("DrillPlayer"));
--]]

-- Header/Footer 
t2[#t2+1]=Def.ActorFrame{
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","header"))..{
		InitCommand=function(self)
			self:x(SCREEN_LEFT);
			self:y(SCREEN_CENTER_Y-15);
		end;
	};
};
t2[#t2+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","footer"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM);
		end;
	};
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","help"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM-16);
			(cmd(SetSecsBetweenSwitches,4;zoom,0.675;maxwidth,(SCREEN_WIDTH-300)/0.675;shadowlength,1;strokecolor,Color("Black");draworder,105;zoomy,0;zoom,1*0.675;linear,0.175))(self);
		end;
	};
};

local oTime=0;
local nTime=0;
local wait=1.0/60;
local sys_offcommand=false;
local function update(self,dt)
	nTime=nTime+dt;
	-- [ja] 1回分の処理 
	if nTime-oTime>wait then
		if getenv("sys_selected") and not sys_offcommand then
			sys_offcommand=true;
			self:queuecommand("Off");
		end;
		if getenv("sys_move") then
			self:queuecommand("SetR");
		end;
		oTime=oTime+wait;
	end;
end;
t2.InitCommand=cmd(SetUpdateFunction,update);
t[#t+1]=t2;
return t;